local assets =
{
	Asset("ATLAS", "images/inventoryimages/seed_berrybush_juicy.xml"),
	Asset("ATLAS", "images/inventoryimages/seed_reeds.xml"),
	Asset("ATLAS", "images/inventoryimages/seed_cactus.xml"),
	Asset("ATLAS", "images/inventoryimages/seed_wormlight_plant.xml"),
	Asset("ATLAS", "images/inventoryimages/seed_wheat.xml"),
}
STRINGS.NAMES.SEED_CACTUS = "仙人掌种子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEED_CACTUS= "仙人掌果肉含有大量水分，沙漠旅行时可以救人一命"
STRINGS.NAMES.SEED_WHEAT = "小麦种子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEED_WHEAT= "粮食危机算是解决了"
STRINGS.NAMES.SEED_WORMLIGHT_PLANT = "发光浆果"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEED_WORMLIGHT_PLANT= "经过改良后即便是白天也能发光了"
local function buildgene(lei)

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("seeds")
    inst.AnimState:SetBuild("seeds")
    inst.AnimState:PlayAnimation("idle",true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
--种植
	local function OnDeploy (inst, pt)
    SpawnPrefab(lei).Transform:SetPosition(pt.x, pt.y, pt.z)
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
--分界线
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "seed_"..lei
    inst.components.inventoryitem.atlasname = "images/inventoryimages/seed_"..lei..".xml"
    inst:AddComponent("selfstacker")
    inst:AddTag("seed")
    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab("seed_"..lei, fn, assets),
MakePlacer("seed_reeds_placer", "grass", "reeds", "idle"),
MakePlacer("seed_berrybush_juicy_placer", "berrybush_juicy", "berrybush_juicy", "idle"),
MakePlacer("seed_wormlight_plant_placer", "worm", "worm", "berry_idle"),
MakePlacer("seed_cactus_placer", "cactus", "cactus", "idle"),
MakePlacer("seed_wheat_placer", "wheat", "wheat", "idle")
end
return 
    buildgene("berrybush_juicy"),
	buildgene("cactus"),
	buildgene("wheat"),
	buildgene("wormlight_plant"),
    buildgene("reeds",true)